# Quick Start Guide

## 📋 Prerequisites
- PHP 7.4+ ✓
- MySQL/MariaDB ✓
- cURL extension enabled ✓
- **Does NOT require Node.js**

## 🚀 5-Minute Setup

### Step 1: Upload Files
Upload all files to your hosting via FTP/SFTP to your `public_html` directory.

### Step 2: Create Database
1. Go to cPanel → phpMyAdmin
2. Create new database: `esportsl_gic`
3. Import `database.sql` file

### Step 3: Configure
```bash
# Rename the file
cp .env.example .env

# Edit .env with your database credentials:
# DB_HOST=localhost
# DB_USER=esportsl_gic
# DB_PASS=esportsl_gic
# DB_NAME=esportsl_gic
```

### Step 4: Verify
Open in browser: `https://yourdomain.com/config_check.php`

Check if all items show ✓ (green)

### Step 5: Test API
Send POST request:
```bash
curl -X POST https://yourdomain.com/api.php \
  -d "game=GROWTOPIA&user_id=Mrshadnic&other_id="
```

Expected response:
```json
{
  "response": true,
  "data": {
    "status": 200,
    "nickname": "Mrshadnic"
  }
}
```

## 📚 Example Usage

### Mobile Legends
```bash
curl -X POST https://yourdomain.com/api.php \
  -d "game=MOBILE_LEGENDS&user_id=604210151&other_id=8425"
```

### Free Fire
```bash
curl -X POST https://yourdomain.com/api_example.php \
  -d "game=FREEFIRE&user_id=116502997&other_id="
```

### Growtopia
```bash
curl -X POST https://yourdomain.com/api_example.php \
  -d "game=GROWTOPIA&user_id=Mrshadnic&other_id="
```

## 🔒 Security

The following have been implemented:
✅ SQL Injection prevention (prepared statements)
✅ Directory access control (.htaccess)
✅ Secure headers
✅ Error handling (no sensitive data leaked)
✅ Configuration file protection

## 📞 Troubleshooting

**"Database connection error"**
- Check database credentials in `.env`
- Verify database exists: `esportsl_gic`
- Ensure user has proper permissions

**"Invalid ID"**
- User ID format may be wrong
- Game might have specific ID format requirements
- Check README.md for each game's format

**"Game not found"**
- Check game code spelling (case-sensitive)
- Refer to supported games list in README.md

## 🧹 Cleanup

After setup, delete these files:
- `config_check.php` (configuration checker)
- `web_example.php` (example usage)
- `.env.example` (template file)

Keep production files:
- `.env` (with real credentials)
- `api_example.php` (main endpoint)
- `src/ApiGames.php` (library)
- `mainconfig.php` (config)
- `.htaccess` (security)
- `database.sql` (backup)

## 📖 For More Info

See `DEPLOYMENT.md` for detailed documentation.

---
**Need help?** Check GitHub: https://github.com/aditamagf/check-ign
