# Deployment Guide - Check IGN API

This is a PHP-based API library for checking game nicknames by account ID. It works with **shared hosting that has PHP support** and does **NOT require Node.js**.

## System Requirements

### Required
- **PHP 7.4+** (PHP 8.0+ recommended)
- **MySQL/MariaDB 5.7+**
- **cURL** extension enabled (for API requests)
- **mysqli** extension enabled (for database operations)

### Optional
- Composer (for package management)
- PHP CLI (for command-line usage)

## Installation Steps

### 1. **Upload Files to Server**

Upload all files to your shared hosting server via FTP/SFTP:
```
/public_html/
├── .htaccess (security rules)
├── .env.example (rename to .env)
├── api_example.php (main API endpoint)
├── web_example.php (example usage)
├── mainconfig.php (database configuration)
├── composer.json
├── database.sql
├── README.md
└── src/
    └── ApiGames.php (core library)
```

### 2. **Create Database**

**Option A: Using phpMyAdmin (easiest for shared hosting)**
1. Log into your hosting control panel (cPanel, Plesk, etc.)
2. Open **phpMyAdmin**
3. Click "New Database" and create database named `esportsl_gic`
4. Select the new database
5. Click "Import" tab
6. Upload/paste contents of `database.sql`
7. Click "Go" to execute

**Option B: Using MySQL Command Line**
```bash
mysql -u username -p password < database.sql
```

### 3. **Configure Database Connection**

**Method 1: Using .env file (Recommended)**
1. Rename `.env.example` to `.env`
2. Edit `.env` with your database credentials:
```
DB_HOST=localhost
DB_USER=esportsl_gic
DB_PASS=esportsl_gic
DB_NAME=esportsl_gic
```

**Method 2: Direct editing (Legacy)**
Edit `mainconfig.php` and update:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'esportsl_gic');
define('DB_PASS', 'esportsl_gic');
define('DB_NAME', 'esportsl_gic');
```

### 4. **Set File Permissions**

For shared hosting, set appropriate permissions:
```bash
chmod 644 .htaccess
chmod 644 api_example.php
chmod 644 web_example.php
chmod 644 mainconfig.php
chmod 755 src/
chmod 644 src/ApiGames.php
```

### 5. **Verify Installation**

Access your API via browser:
```
https://yourdomain.com/api_example.php
```

You should see:
```json
{"response": false, "data": {"msg": "Invalid Request"}}
```

## Usage

### API Endpoint: `api_example.php`

Send a POST request with the following parameters:

```bash
curl -X POST https://yourdomain.com/api_example.php \
  -d "game=MOBILE_LEGENDS&user_id=604210151&other_id=8425"
```

**Parameters:**
- `game` - Game code (e.g., `MOBILE_LEGENDS`, `FREEFIRE`, `GROWTOPIA`)
- `user_id` - User/Player ID
- `other_id` - Additional ID (zone ID, server ID, etc.) - use empty string if not needed

**Response:**
```json
{
  "response": true,
  "data": {
    "status": 200,
    "nickname": "PlayerName"
  }
}
```

### Supported Games

See `README.md` for the complete list of supported games and their codes. Some popular games:
- `MOBILE_LEGENDS` - Mobile Legends: Bang Bang
- `FREEFIRE` - Free Fire
- `GROWTOPIA` - Growtopia
- `GENSHIN_IMPACT` - Genshin Impact
- And 50+ more games...

## Security Features

✅ **SQL Injection Prevention** - Uses prepared statements for all database queries
✅ **XSS Protection** - Output escaping and Content-Type headers
✅ **File Protection** - `.htaccess` blocks direct access to config files
✅ **HTTP Security Headers** - X-Frame-Options, X-Content-Type-Options, etc.
✅ **Error Handling** - No sensitive database errors exposed to clients

## Troubleshooting

### "Database connection error"
- Verify database credentials in `.env` or `mainconfig.php`
- Ensure database user has proper permissions
- Check if MySQL service is running

### "Invalid ID" response
- Verify the game code is correct
- Ensure user_id and other_id are accurate
- Check game-specific ID format requirements

### "Game not found"
- Check spelling of game code (case-sensitive)
- Refer to README.md for correct game codes
- Update `ApiGames.php` if new games need to be added

### 500 Internal Server Error
- Check PHP error logs in your hosting control panel
- Verify PHP version is 7.4+
- Ensure cURL extension is enabled
- Review file permissions

### Permission Denied on `.htaccess`
- Some shared hosts don't allow `.htaccess` modifications
- Contact your hosting provider to enable mod_rewrite
- Alternatively, request they manually restrict file access

## Environment Variables

If using `.env` file, the following variables are supported:

```
DB_HOST    = Database hostname (default: localhost)
DB_USER    = Database username (default: esportsl_gic)
DB_PASS    = Database password (default: esportsl_gic)
DB_NAME    = Database name (default: esportsl_gic)
```

## Production Checklist

- [ ] Database created and schema imported
- [ ] `.env` file configured with production credentials
- [ ] `.env` file is in `.gitignore` (not committed to version control)
- [ ] `.htaccess` deployed (if server supports it)
- [ ] File permissions set correctly
- [ ] Tested API endpoint and received valid response
- [ ] PHP error logging enabled but errors not displayed to users
- [ ] HTTPS enabled on your domain
- [ ] Database backups scheduled

## Updating

To update the library:
1. Backup your database
2. Backup your `.env` file
3. Update files (keeping `mainconfig.php` and `.env` intact)
4. Check `database.sql` for schema changes
5. Run any database migrations

## Support

- Issues: https://github.com/aditamagf/check-ign/issues
- Original Package: https://packagist.org/packages/aditamagf/check-ign

## License

MIT License - See LICENSE file for details

---

**Note:** This application does NOT require Node.js and works on standard PHP shared hosting with MySQL/MariaDB support.
